#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{

	
	

	[TestFixture]
	public class BOL_TransfusionReaction : BaseTest 
	{
		private DataTable _dtTransfusionReaction;
		
		private BOL.TransfusionReaction _tstTR;

		[SetUp]
		protected void SetUp() 
		{				
			this.BaseSetUp();

			if (this.RefreshData)
			{
				_dtTransfusionReaction = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM TransfusionReaction ", true);
				this.RefreshData = false;
			}

			this._tstTR = new BOL.TransfusionReaction(_dtTransfusionReaction.Rows[0]);
		}

		[Test]
		public void Ctor_Pass()
		{
			BOL.TransfusionReaction tmpTR = new BOL.TransfusionReaction();

			Assert.IsNotNull(tmpTR);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_Fail()
		{
		}

		[Test]
		public void Ctor_DataRow_Pass()
		{
			BOL.TransfusionReaction tmpTR = new BOL.TransfusionReaction(this._dtTransfusionReaction.Rows[0]);

			Assert.IsNotNull(tmpTR);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_DataRow_Fail()
		{
		}

		[Test]
		public void BagReturnedIndicator_Pass()
		{
			bool tstValue = (!this._tstTR.BagReturnedIndicator);

			this._tstTR.BagReturnedIndicator = tstValue;

			Assert.AreEqual(this._tstTR.BagReturnedIndicator, tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void BagReturnedIndicator_Fail()
		{
		}

		[Test]
		public void BagHemolysisInspectionCode_Pass()
		{
			string tstValue = System.DateTime.Now.ToString();

			this._tstTR.BagHemolysisInspectionCode = tstValue;

			Assert.AreEqual(this._tstTR.BagHemolysisInspectionCode, tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void BagHemolysisInspectionCode_Fail()
		{
		}

		[Test]
		public void BagClericalChecksOkIndicator_Pass()
		{
			bool tstValue = (!this._tstTR.BagReturnedIndicator);

			this._tstTR.BagClericalChecksOkIndicator = tstValue;

			Assert.AreEqual(this._tstTR.BagClericalChecksOkIndicator, tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void BagClericalChecksOkIndicator_Fail()
		{
		}

		[Test]
		public void PatientTransfusionGuid_Pass()
		{
			System.Guid tstValue = System.Guid.NewGuid();

			this._tstTR.PatientTransfusionGuid = tstValue;

			Assert.AreEqual(this._tstTR.PatientTransfusionGuid, tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void PatientTransfusionGuid_Fail()
		{
		}

		[Test]
		public void PatientTransfusionReactionGuid_Pass()
		{
			System.Guid tstValue = System.Guid.NewGuid();

			this._tstTR.PatientTransfusionReactionGuid = tstValue;

			Assert.AreEqual(this._tstTR.PatientTransfusionReactionGuid, tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void PatientTransfusionReactionGuid_Fail()
		{
		}

		[Test]
		public void TransfusionReactionGuid_Pass()
		{
			System.Guid tstValue = System.Guid.NewGuid();

			this._tstTR.TransfusionReactionGuid = tstValue;

			Assert.AreEqual(this._tstTR.TransfusionReactionGuid, tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void TransfusionReactionGuid_Fail()
		{
		}

		[Test]
		public void LoadDataRowFromThis_Pass()
		{
			DataRow drTest = this._tstTR.LoadDataRowFromThis(this._dtTransfusionReaction.NewRow());

			Assert.IsNotNull(drTest);
			Assert.AreEqual(drTest[TABLES.TransfusionReaction.TransfusionReactionGuid].ToString(), this._tstTR.TransfusionReactionGuid.ToString());
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void LoadDataRowFromThis_Fail()
		{
		}


		[Test]
		public void TagNotScannedIndicator_Pass()
		{
			this._tstTR.TagNotScannedIndicator = true;
			Assert.AreEqual(this._tstTR.TagNotScannedIndicator, true);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void TagNotScannedIndicator_Fail()
		{
		}


	}
}
#endif
